 %-------------------------------------------------------------------------%
% Filename: figs_App_D_5_6_7_data.m  
% Part of the paper "CS4ML: A general framework for active learning with
% arbitrary data based on Christoffel functions"
% 
% Description: generates and saves the data for Figure 13 in Appendix D, 
% surrogate Christoffel function for collocation, initial, and boundary 
% data.
%-------------------------------------------------------------------------%
% Inputs:
% fig_num - figure number (3)
% row_num - row number (either 1, 2 or 3)
% col_num - column number (either 1 or 2)
%-------------------------------------------------------------------------%

function fig_App_D_5_6_7_data(fig_num,row_num)
 
% Define name
fig_name = ['fig_AppD','_',num2str(fig_num),'_',num2str(row_num)];

% Define parameters
nb_trials = 20;  
nb_samp   = 2;

nb_col_pts   = 10000;
nb_init_pts  = 102;
nb_bound_pts = 202;

x_values_data = zeros(nb_col_pts, nb_trials, nb_samp);
y_values_data = zeros(nb_init_pts, nb_trials, nb_samp);  
z_values_data = zeros(nb_bound_pts, nb_trials, nb_samp); 

%%% Main loop %%%  
 
% load parameters
load_param_fig_App_D_5
                                      
disp(filename)
load([filename '_extracted_data.mat']);
       
% save data for samp method and trial
for samp_num = 1:nb_samp
    for t = 1:nb_trials 
        x_values_samp(:,t,samp_num) = Prob_plot_col_dist_save_data(samp_num,t,:);
        y_values_samp(:,t,samp_num) = Prob_plot_init_dist_save_data(samp_num,t,:);
        z_values_samp(:,t,samp_num) = Prob_plot_bound_dist_save_data(samp_num,t,:);
    end
end
 
% save full data  
x_values_data(:,:, 1:2) = x_values_samp;
y_values_data(:,:, 1:2) = y_values_samp;  
z_values_data(:,:, 1:2) = z_values_samp;  

%%% Save data %%%
save(['../../data/Figure App D 5 6 7/',fig_name], 'x_values_data', 'y_values_data','z_values_data');

end